// Copyright (C) 2021 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial

#ifndef QLOCATION_GEOADDRESS_P_H
#define QLOCATION_GEOADDRESS_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <QString>
#include <QSharedData>
#include <private/qglobal_p.h>

QT_BEGIN_NAMESPACE

// The fields for the class are based on the nominatim openstreetmap API:
// https://nominatim.org/release-docs/latest/api/Output/#addressdetails
// It might not reflect all the address levels, but can be used to provide a
// more or less well-formed address.
class QGeoAddressPrivate : public QSharedData
{
public:
    QGeoAddressPrivate();
    QGeoAddressPrivate(const QGeoAddressPrivate &other);
    ~QGeoAddressPrivate();

    QString sCountry; //!< country field
    QString sCountryCode; //!< country code field
    QString sState; //!< state field
    QString sCounty; //!< county field
    QString sCity; //!< city field
    QString sDistrict; //!< district field
    QString sStreet; //!< street name field
    QString sStreetNumber; //!< street number field
    QString sPostalCode; //!< postal code field
    QString sText;
    bool m_autoGeneratedText;
};

QT_END_NAMESPACE

#endif
